﻿
namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects
{
    /// <summary>
    /// Struct containing information about gap.
    /// </summary>
    struct Gap
    {
        /// <summary>
        /// Length of the gap.
        /// </summary>
        internal double Length;

        /// <summary>
        /// Acceleration of the following car. May be negative to represent slowing down.
        /// </summary>
        internal int FollowingCarAcceleration;

        /// <summary>
        /// Constructor of gap by its length. The following car acceleration is set to zero.
        /// </summary>
        /// <param name="length">Length of the gap.</param>
        internal Gap(double length)
        {
            Length = length;
            FollowingCarAcceleration = 0;
        }

        /// <summary>
        /// Constructor of gap by its length and following car acceleration.
        /// </summary>
        /// <param name="length">Length of the gap.</param>
        /// <param name="followingcarAcceleration">Following car acceleration.</param>
        internal Gap(double length, int followingcarAcceleration)
        {
            Length = length;
            FollowingCarAcceleration = followingcarAcceleration;
        }
    }
}
